import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:razinsoft_rider/gen/assets.gen.dart';

class LoadingView extends StatelessWidget {
  final String? message;
  final Widget? loadingWidget;
  final double height;
  final double width;
  const LoadingView({
    super.key,
    this.message,
    this.loadingWidget,
    this.height = 120,
    this.width = 120,
  });

  @override
  Widget build(BuildContext context) => Center(
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          loadingWidget ?? Assets.lottie.loading.lottie(height: height.h, width: width.w, fit: BoxFit.fill),
          if (message != null)
            Padding(
              padding: const EdgeInsets.only(top: 16.0),
              child: Text(
                message!,
                style: Theme.of(context).textTheme.bodyLarge,
                textAlign: TextAlign.center,
              ),
            )
        ],
      ),
    );
}
